
//
// To jest przykadowy kod z podrozdziau 24.5.3 Macierze dwuwymiarowe ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "Matrix.h"

using namespace Numeric_lib;

//------------------------------------------------------------------------------

int f(int a) { return a*a; }

//------------------------------------------------------------------------------

int g(int a, int b) { return a*b; }

//------------------------------------------------------------------------------

enum Piece { none, pawn, knight, queen, king, bishop, rook};

//------------------------------------------------------------------------------

void board()
{
    //enum Piece { none, pawn, knight, queen, king, bishop, rook };
    Matrix<Piece,2> board(8,8);        // szachownica

    const int white_start_row = 0;
    const int black_start_row = 7;

    //Matrix<Piece>& white_start = board[0]; // Dziaa w MS C++, ale nie dziaa w ISO C++; wie si z r-wartoci
    //Matrix<Piece>& red_start = board[7];

    Piece a[] = { rook, knight, bishop, queen, king, bishop, knight, rook};
    Matrix<Piece> start_row(a); // = { castle, knight, bishop, queen, king, bishop, knight, castle};
    Matrix<Piece> clear_row(8);

    board[white_start_row] = start_row;    // resetuje biae figury
    for (int i = 1; i<7; ++i) board[i] = clear_row;    // czyci rodek planszy
    board[black_start_row] = start_row;    // resetuje czarne figury
}

//------------------------------------------------------------------------------

int main()
{
    Matrix<int,2> a(3,4);

    int s  = a.size();    // liczba elementw
    int d1 = a.dim1();     // liczba elementw w wierszu
    int d2 = a.dim2();    // liczba elementw w kolumnie
    int* p = a.data();    // Wyodrbnia dane jako wskanik do tablicy w stylu jzyka C.

    int  i = 1;
    int  j = 2;
    int  n = 2;
    a(i,j);               // (i,j)-ty element (styl jzyka Fortran), ale ze sprawdzaniem zakresu
    a[i];                 // i-ty wiersz (styl jzyka C), ze sprawdzaniem zakresu
    a[i][j];              // (i,j)-ty element (styl jzyka C)

    a.slice(i);           // wiersze od elementu a[i] do ostatniego
    a.slice(i,n);         // wiersze od elementu a[i] do a[i+n1].

    Matrix<int,2> a2 = a; // inicjowanie kopiujce
    a = a2;               // przypisanie kopiujce
    a *= 7;               // skalowanie (take +=, =, /=, itp.)
    a.apply(f);           // a(i,j)=f(a(i,j)) dla kadego elementu a(i,j)
    a.apply(g,7);         // a(i,j)=f(a(i,j),7) dla kadego elementu a(i,j)
    Matrix<int,2> b(3,4);
    b=apply(f,a);         // Tworzy now macierz, w ktrej b(i,j)==f(a(i,j))
    b=apply(g,a,7);       // Tworzy now macierz, w ktrej b(i,j)==f(a(i,j),7)

    a.swap_rows(1,2);     // Zamienia wiersze  a[1] <> a[2].

    board();
}

//------------------------------------------------------------------------------
